/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoinj.net.discovery;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import okhttp3.OkHttpClient;
import org.bitcoinj.core.NetworkParameters;
import org.bitcoinj.net.discovery.DnsDiscovery;
import org.bitcoinj.net.discovery.HttpDiscovery;
import org.bitcoinj.net.discovery.PeerDiscovery;
import org.bitcoinj.net.discovery.PeerDiscoveryException;
import org.bitcoinj.utils.ContextPropagatingThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiplexingDiscovery
implements PeerDiscovery {
    private static final Logger log = LoggerFactory.getLogger(MultiplexingDiscovery.class);
    protected final List<PeerDiscovery> seeds;
    protected final NetworkParameters netParams;
    private volatile ExecutorService vThreadPool;

    public static MultiplexingDiscovery forServices(NetworkParameters params, long services, boolean ignoreHttpSeeds) {
        String[] dnsSeeds;
        ArrayList<PeerDiscovery> discoveries = Lists.newArrayList();
        HttpDiscovery.Details[] httpSeeds = params.getHttpSeeds();
        if (!ignoreHttpSeeds && httpSeeds != null) {
            OkHttpClient httpClient = new OkHttpClient();
            for (HttpDiscovery.Details httpSeed : httpSeeds) {
                discoveries.add(new HttpDiscovery(params, httpSeed, httpClient));
            }
        }
        if ((dnsSeeds = params.getDnsSeeds()) != null) {
            for (String dnsSeed : dnsSeeds) {
                discoveries.add(new DnsDiscovery.DnsSeedDiscovery(params, dnsSeed));
            }
        }
        return new MultiplexingDiscovery(params, discoveries);
    }

    public MultiplexingDiscovery(NetworkParameters params, List<PeerDiscovery> seeds) {
        Preconditions.checkArgument(!seeds.isEmpty());
        this.netParams = params;
        this.seeds = seeds;
    }

    @Override
    public InetSocketAddress[] getPeers(final long services, final long timeoutValue, final TimeUnit timeoutUnit) throws PeerDiscoveryException {
        this.vThreadPool = this.createExecutor();
        try {
            ArrayList<1> tasks = Lists.newArrayList();
            for (final PeerDiscovery seed : this.seeds) {
                tasks.add(new Callable<InetSocketAddress[]>(){

                    @Override
                    public InetSocketAddress[] call() throws Exception {
                        return seed.getPeers(services, timeoutValue, timeoutUnit);
                    }
                });
            }
            List futures = this.vThreadPool.invokeAll(tasks, timeoutValue, timeoutUnit);
            ArrayList addrs = Lists.newArrayList();
            for (int i = 0; i < futures.size(); ++i) {
                InetSocketAddress[] inetAddresses;
                Future future = futures.get(i);
                if (future.isCancelled()) {
                    log.warn("Seed {}: timed out", (Object)this.seeds.get(i));
                    continue;
                }
                try {
                    inetAddresses = (InetSocketAddress[])future.get();
                }
                catch (ExecutionException e) {
                    log.warn("Seed {}: failed to look up: {}", (Object)this.seeds.get(i), (Object)e.getMessage());
                    continue;
                }
                Collections.addAll(addrs, inetAddresses);
            }
            if (addrs.size() == 0) {
                throw new PeerDiscoveryException("No peer discovery returned any results in " + timeoutUnit.toMillis(timeoutValue) + "ms. Check internet connection?");
            }
            Collections.shuffle(addrs);
            this.vThreadPool.shutdownNow();
            InetSocketAddress[] inetSocketAddressArray = addrs.toArray(new InetSocketAddress[addrs.size()]);
            return inetSocketAddressArray;
        }
        catch (InterruptedException e) {
            throw new PeerDiscoveryException(e);
        }
        finally {
            this.vThreadPool.shutdown();
        }
    }

    protected ExecutorService createExecutor() {
        return Executors.newFixedThreadPool(this.seeds.size(), new ContextPropagatingThreadFactory("Multiplexing discovery"));
    }

    @Override
    public void shutdown() {
        ExecutorService tp = this.vThreadPool;
        if (tp != null) {
            tp.shutdown();
        }
    }
}

