/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoinj.params;

import com.google.common.base.Preconditions;
import java.net.URI;
import org.bitcoinj.core.ECKey;
import org.bitcoinj.core.Sha256Hash;
import org.bitcoinj.core.Utils;
import org.bitcoinj.net.discovery.HttpDiscovery;
import org.bitcoinj.params.AbstractBitcoinNetParams;

public class MainNetParams
extends AbstractBitcoinNetParams {
    public static final int MAINNET_MAJORITY_WINDOW = 1000;
    public static final int MAINNET_MAJORITY_REJECT_BLOCK_OUTDATED = 950;
    public static final int MAINNET_MAJORITY_ENFORCE_BLOCK_UPGRADE = 750;
    private static MainNetParams instance;

    public MainNetParams() {
        this.interval = 2016;
        this.targetTimespan = 1209600;
        this.maxTarget = Utils.decodeCompactBits(486604799L);
        this.dumpedPrivateKeyHeader = 128;
        this.addressHeader = 0;
        this.p2shHeader = 5;
        this.segwitAddressHrp = "bc";
        this.port = 8333;
        this.packetMagic = 4190024921L;
        this.bip32HeaderP2PKHpub = 76067358;
        this.bip32HeaderP2PKHpriv = 76066276;
        this.bip32HeaderP2WPKHpub = 78792518;
        this.bip32HeaderP2WPKHpriv = 78791436;
        this.majorityEnforceBlockUpgrade = 750;
        this.majorityRejectBlockOutdated = 950;
        this.majorityWindow = 1000;
        this.genesisBlock.setDifficultyTarget(486604799L);
        this.genesisBlock.setTime(1231006505L);
        this.genesisBlock.setNonce(2083236893L);
        this.id = "org.bitcoin.production";
        this.subsidyDecreaseBlockCount = 210000;
        this.spendableCoinbaseDepth = 100;
        String genesisHash = this.genesisBlock.getHashAsString();
        Preconditions.checkState(genesisHash.equals("000000000019d6689c085ae165831e934ff763ae46a2a6c172b3f1b60a8ce26f"), genesisHash);
        this.checkpoints.put(91722, Sha256Hash.wrap("00000000000271a2dc26e7667f8419f2e15416dc6955e5a6c6cdf3f2574dd08e"));
        this.checkpoints.put(91812, Sha256Hash.wrap("00000000000af0aed4792b1acee3d966af36cf5def14935db8de83d6f9306f2f"));
        this.checkpoints.put(91842, Sha256Hash.wrap("00000000000a4d0a398161ffc163c503763b1f4360639393e0e4c8e300e0caec"));
        this.checkpoints.put(91880, Sha256Hash.wrap("00000000000743f190a18c5577a3c2d2a1f610ae9601ac046a38084ccb7cd721"));
        this.checkpoints.put(200000, Sha256Hash.wrap("000000000000034a7dedef4a161fa058a2d67a173a90155f3a2fe6fc132e0ebf"));
        this.dnsSeeds = new String[]{"seed.bitcoin.sipa.be", "dnsseed.bluematt.me", "dnsseed.bitcoin.dashjr.org", "seed.bitcoinstats.com", "seed.bitcoin.jonasschnelli.ch", "seed.btc.petertodd.org", "seed.bitcoin.sprovoost.nl", "dnsseed.emzy.de"};
        this.httpSeeds = new HttpDiscovery.Details[]{new HttpDiscovery.Details(ECKey.fromPublicOnly(Utils.HEX.decode("0238746c59d46d5408bf8b1d0af5740fe1a6e1703fcb56b2953f0b965c740d256f")), URI.create("http://httpseed.bitcoin.schildbach.de/peers")), new HttpDiscovery.Details(ECKey.fromPublicOnly(Utils.HEX.decode("02c682e83db4efac3c841d6fa544211fb1e4a55061060019b3682fc306f228c558")), URI.create("http://lightning-wallet.com:8081/peers"))};
        this.addrSeeds = new int[]{293371416, 308549973, 410019118, 503235513, 1244858420, 1532180525, 2007739555, 165925740, -1599807020, -1569334841, -1568621493, -1525867658, 174032075, -1469262403, -1275844678, -956543792, -952362567, -653928353, -652609107, -633355502, -598956615, -477171621, -305230249, -158674370, -79979431, 274847839, 760423856, 889581457, 1279439180, 1648152178, 108938280, 1799873326, 1850204974, -2018585761, -1761725900, -1400815201, -1225147611, -908217159, -874992477, -715388496, -714865128, -626453426, -541486968, -533490096, -343793233, -54536357, 42903086, 754542782, 765259811, 1005434898, 1077360453, 1084921936, 1112558120, 1354298965, 1518789960, 1836708953, 1885870913, 1957220127, 2006070228, -1960607566, -1647561681, -1557023315, -1453634416, -1335888048, 201188308, 202752310, -745462446, -714283363, -659598252, -52133784, 281164341, 292074019, 296650527, 350080564, 26010581, 455354676, 549254996, 865422643, 894831024, 972890159, 1307794991, 1327755819, 1460140130, -2046640690, -1911984066, -1879007522, -1610935717, -1556329328, -1446712233, -1439870825, -1370293356, 15541814, -302685025, 255960764, -33304798, 588619224, 915401301, 1354580017, 1402330732, 96899119, 1623233360, 1725354344, 1893270327, 2052364995, -1877813934, -1801056461, -1534001354, -1338976942, -1334668208, -1322562486, 192839264, -990360785, -986450897, -923398462, -909002055, -752235660, -458069324, -418488912, -335077324, 279712322, 320621177, 343398983, 681176163, 1164313681, 1260060752, 1764872386, 118413407, -2140497584, -2135894750, -2129843263, -2103624821, -2071208016, -2019171026, -1771783387, -1608407329, 174032200, 174507858, -1426737585, -1413855670, -975224475, -389681195, -100085729, 339870744, 519952784, 853463610, 911089236, 964809314, 967732947, 1363388057, 1761108427, 1864539683, 1877237134, 2010843568, 2048710751, -1915733109, -1834038845, -1562461405, -1535250864, -1286181964, -887601735, -850279853, -717138099, -523523786, -80992560, 383834041, 387564217, 517984330, 679411501, 687164990, 896844220, 921810127, 959600411, 1030724540, 1146661434, 1305661266, 88620695, 1436331733, 1497981521, 1725182662, 1963063239, 2004179359, -1911643509, -1891824227, -1876519458, -1498570117, -1157593253, -1138308743, -777861750, -153928821, -103196345};
    }

    public static synchronized MainNetParams get() {
        if (instance == null) {
            instance = new MainNetParams();
        }
        return instance;
    }

    @Override
    public String getPaymentProtocolId() {
        return "main";
    }
}

