/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoinj.protocols.channels;

import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import com.google.protobuf.ByteString;
import java.io.IOException;
import java.net.InetSocketAddress;
import javax.annotation.Nullable;
import org.bitcoin.paymentchannel.Protos;
import org.bitcoinj.core.Coin;
import org.bitcoinj.core.ECKey;
import org.bitcoinj.core.InsufficientMoneyException;
import org.bitcoinj.core.Sha256Hash;
import org.bitcoinj.core.Utils;
import org.bitcoinj.net.NioClient;
import org.bitcoinj.net.ProtobufConnection;
import org.bitcoinj.protocols.channels.IPaymentChannelClient;
import org.bitcoinj.protocols.channels.PaymentChannelClient;
import org.bitcoinj.protocols.channels.PaymentChannelClientState;
import org.bitcoinj.protocols.channels.PaymentChannelCloseException;
import org.bitcoinj.protocols.channels.PaymentIncrementAck;
import org.bitcoinj.protocols.channels.ValueOutOfRangeException;
import org.bitcoinj.wallet.Wallet;
import org.bouncycastle.crypto.params.KeyParameter;

public class PaymentChannelClientConnection {
    private final SettableFuture<PaymentChannelClientConnection> channelOpenFuture = SettableFuture.create();
    private final PaymentChannelClient channelClient;
    private final ProtobufConnection<Protos.TwoWayChannelMessage> wireParser;

    public PaymentChannelClientConnection(InetSocketAddress server, int timeoutSeconds, Wallet wallet, ECKey myKey, Coin maxValue, String serverId) throws IOException, ValueOutOfRangeException {
        this(server, timeoutSeconds, wallet, myKey, maxValue, serverId, null);
    }

    public PaymentChannelClientConnection(InetSocketAddress server, int timeoutSeconds, Wallet wallet, ECKey myKey, Coin maxValue, String serverId, @Nullable KeyParameter userKeySetup) throws IOException, ValueOutOfRangeException {
        this(server, timeoutSeconds, wallet, myKey, maxValue, serverId, userKeySetup, PaymentChannelClient.defaultChannelProperties);
    }

    public PaymentChannelClientConnection(InetSocketAddress server, int timeoutSeconds, Wallet wallet, ECKey myKey, Coin maxValue, String serverId, @Nullable KeyParameter userKeySetup, final IPaymentChannelClient.ClientChannelProperties clientChannelProperties) throws IOException, ValueOutOfRangeException {
        this.channelClient = new PaymentChannelClient(wallet, myKey, maxValue, Sha256Hash.of(serverId.getBytes()), userKeySetup, clientChannelProperties, new IPaymentChannelClient.ClientConnection(){

            @Override
            public void sendToServer(Protos.TwoWayChannelMessage msg) {
                PaymentChannelClientConnection.this.wireParser.write(msg);
            }

            @Override
            public void destroyConnection(PaymentChannelCloseException.CloseReason reason) {
                PaymentChannelClientConnection.this.channelOpenFuture.setException(new PaymentChannelCloseException("Payment channel client requested that the connection be closed: " + (Object)((Object)reason), reason));
                PaymentChannelClientConnection.this.wireParser.closeConnection();
            }

            @Override
            public boolean acceptExpireTime(long expireTime) {
                return expireTime <= clientChannelProperties.timeWindow() + Utils.currentTimeSeconds() + 60L;
            }

            @Override
            public void channelOpen(boolean wasInitiated) {
                PaymentChannelClientConnection.this.wireParser.setSocketTimeout(0);
                PaymentChannelClientConnection.this.channelOpenFuture.set(PaymentChannelClientConnection.this);
            }
        });
        this.wireParser = new ProtobufConnection<Protos.TwoWayChannelMessage>(new ProtobufConnection.Listener<Protos.TwoWayChannelMessage>(){

            @Override
            public void messageReceived(ProtobufConnection<Protos.TwoWayChannelMessage> handler, Protos.TwoWayChannelMessage msg) {
                try {
                    PaymentChannelClientConnection.this.channelClient.receiveMessage(msg);
                }
                catch (InsufficientMoneyException e) {
                    PaymentChannelClientConnection.this.channelOpenFuture.setException(e);
                }
            }

            @Override
            public void connectionOpen(ProtobufConnection<Protos.TwoWayChannelMessage> handler) {
                PaymentChannelClientConnection.this.channelClient.connectionOpen();
            }

            @Override
            public void connectionClosed(ProtobufConnection<Protos.TwoWayChannelMessage> handler) {
                PaymentChannelClientConnection.this.channelClient.connectionClosed();
                PaymentChannelClientConnection.this.channelOpenFuture.setException(new PaymentChannelCloseException("The TCP socket died", PaymentChannelCloseException.CloseReason.CONNECTION_CLOSED));
            }
        }, Protos.TwoWayChannelMessage.getDefaultInstance(), Short.MAX_VALUE, timeoutSeconds * 1000);
        new NioClient(server, this.wireParser, timeoutSeconds * 1000);
    }

    public ListenableFuture<PaymentChannelClientConnection> getChannelOpenFuture() {
        return this.channelOpenFuture;
    }

    public ListenableFuture<PaymentIncrementAck> incrementPayment(Coin size) throws ValueOutOfRangeException, IllegalStateException {
        return this.channelClient.incrementPayment(size, null, null);
    }

    public ListenableFuture<PaymentIncrementAck> incrementPayment(Coin size, @Nullable ByteString info, @Nullable KeyParameter userKey) throws ValueOutOfRangeException, IllegalStateException {
        return this.channelClient.incrementPayment(size, info, userKey);
    }

    public PaymentChannelClientState state() {
        return this.channelClient.state();
    }

    public void settle() {
        try {
            this.channelClient.settle();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void disconnectWithoutSettlement() {
        this.wireParser.closeConnection();
    }
}

