/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoinj.protocols.channels;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import java.util.Locale;

public class StateMachine<State extends Enum<State>> {
    private State currentState;
    private final Multimap<State, State> transitions;

    public StateMachine(State startState, Multimap<State, State> transitions) {
        this.currentState = (Enum)Preconditions.checkNotNull(startState);
        this.transitions = Preconditions.checkNotNull(transitions);
    }

    public synchronized void checkState(State requiredState) throws IllegalStateException {
        if (requiredState != this.currentState) {
            throw new IllegalStateException(String.format(Locale.US, "Expected state %s, but in state %s", requiredState, this.currentState));
        }
    }

    public synchronized void checkState(State ... requiredStates) throws IllegalStateException {
        for (State requiredState : requiredStates) {
            if (!((Enum)requiredState).equals(this.currentState)) continue;
            return;
        }
        throw new IllegalStateException(String.format(Locale.US, "Expected states %s, but in state %s", Lists.newArrayList(requiredStates), this.currentState));
    }

    public synchronized void transition(State newState) throws IllegalStateException {
        if (!this.transitions.containsEntry(this.currentState, newState)) {
            throw new IllegalStateException(String.format(Locale.US, "Attempted invalid transition from %s to %s", this.currentState, newState));
        }
        this.currentState = newState;
    }

    public synchronized State getState() {
        return this.currentState;
    }

    public String toString() {
        return "" + '[' + this.getState() + ']';
    }
}

