/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoinj.signers;

import java.util.EnumSet;
import org.bitcoinj.core.Coin;
import org.bitcoinj.core.ECKey;
import org.bitcoinj.core.Transaction;
import org.bitcoinj.core.TransactionInput;
import org.bitcoinj.core.TransactionOutput;
import org.bitcoinj.core.TransactionWitness;
import org.bitcoinj.crypto.DeterministicKey;
import org.bitcoinj.crypto.TransactionSignature;
import org.bitcoinj.script.Script;
import org.bitcoinj.script.ScriptBuilder;
import org.bitcoinj.script.ScriptException;
import org.bitcoinj.script.ScriptPattern;
import org.bitcoinj.signers.TransactionSigner;
import org.bitcoinj.wallet.KeyBag;
import org.bitcoinj.wallet.RedeemData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalTransactionSigner
implements TransactionSigner {
    private static final Logger log = LoggerFactory.getLogger(LocalTransactionSigner.class);
    private static final EnumSet<Script.VerifyFlag> MINIMUM_VERIFY_FLAGS = EnumSet.of(Script.VerifyFlag.P2SH, Script.VerifyFlag.NULLDUMMY);

    @Override
    public boolean isReady() {
        return true;
    }

    @Override
    public boolean signInputs(TransactionSigner.ProposedTransaction propTx, KeyBag keyBag) {
        Transaction tx = propTx.partialTx;
        int numInputs = tx.getInputs().size();
        for (int i = 0; i < numInputs; ++i) {
            TransactionInput txIn = tx.getInput(i);
            TransactionOutput connectedOutput = txIn.getConnectedOutput();
            if (connectedOutput == null) {
                log.warn("Missing connected output, assuming input {} is already signed.", (Object)i);
                continue;
            }
            Script scriptPubKey = connectedOutput.getScriptPubKey();
            try {
                txIn.getScriptSig().correctlySpends(tx, i, txIn.getWitness(), connectedOutput.getValue(), connectedOutput.getScriptPubKey(), MINIMUM_VERIFY_FLAGS);
                log.warn("Input {} already correctly spends output, assuming SIGHASH type used will be safe and skipping signing.", (Object)i);
                continue;
            }
            catch (ScriptException scriptException) {
                ECKey key;
                RedeemData redeemData = txIn.getConnectedRedeemData(keyBag);
                ECKey pubKey = redeemData.keys.get(0);
                if (pubKey instanceof DeterministicKey) {
                    propTx.keyPaths.put(scriptPubKey, ((DeterministicKey)pubKey).getPath());
                }
                if ((key = redeemData.getFullKey()) == null) {
                    log.warn("No local key found for input {}", (Object)i);
                    continue;
                }
                Script inputScript = txIn.getScriptSig();
                byte[] script = redeemData.redeemScript.getProgram();
                try {
                    if (ScriptPattern.isP2PK(scriptPubKey) || ScriptPattern.isP2PKH(scriptPubKey) || ScriptPattern.isP2SH(scriptPubKey)) {
                        TransactionSignature signature = tx.calculateSignature(i, key, script, Transaction.SigHash.ALL, false);
                        int sigIndex = 0;
                        inputScript = scriptPubKey.getScriptSigWithSignature(inputScript, signature.encodeToBitcoin(), sigIndex);
                        txIn.setScriptSig(inputScript);
                        txIn.setWitness(null);
                        continue;
                    }
                    if (ScriptPattern.isP2WPKH(scriptPubKey)) {
                        Script scriptCode = ScriptBuilder.createP2PKHOutputScript(key);
                        Coin value = txIn.getValue();
                        TransactionSignature signature = tx.calculateWitnessSignature(i, key, scriptCode, value, Transaction.SigHash.ALL, false);
                        txIn.setScriptSig(ScriptBuilder.createEmpty());
                        txIn.setWitness(TransactionWitness.redeemP2WPKH(signature, key));
                        continue;
                    }
                    throw new IllegalStateException(script.toString());
                }
                catch (ECKey.KeyIsEncryptedException e) {
                    throw e;
                }
                catch (ECKey.MissingPrivateKeyException e) {
                    log.warn("No private key in keypair for input {}", (Object)i);
                }
            }
        }
        return true;
    }
}

