/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoinj.store;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nullable;
import org.bitcoinj.core.ECKey;
import org.bitcoinj.core.LegacyAddress;
import org.bitcoinj.core.NetworkParameters;
import org.bitcoinj.core.Sha256Hash;
import org.bitcoinj.core.StoredBlock;
import org.bitcoinj.core.StoredUndoableBlock;
import org.bitcoinj.core.Transaction;
import org.bitcoinj.core.UTXO;
import org.bitcoinj.core.UTXOProviderException;
import org.bitcoinj.core.VerificationException;
import org.bitcoinj.store.BlockStoreException;
import org.bitcoinj.store.FullPrunedBlockStore;
import org.bitcoinj.store.StoredTransactionOutPoint;
import org.bitcoinj.store.TransactionalHashMap;
import org.bitcoinj.store.TransactionalMultiKeyHashMap;

public class MemoryFullPrunedBlockStore
implements FullPrunedBlockStore {
    private TransactionalHashMap<Sha256Hash, StoredBlockAndWasUndoableFlag> blockMap = new TransactionalHashMap();
    private TransactionalMultiKeyHashMap<Sha256Hash, Integer, StoredUndoableBlock> fullBlockMap = new TransactionalMultiKeyHashMap();
    private TransactionalHashMap<StoredTransactionOutPoint, UTXO> transactionOutputMap = new TransactionalHashMap();
    private StoredBlock chainHead;
    private StoredBlock verifiedChainHead;
    private int fullStoreDepth;
    private NetworkParameters params;

    public MemoryFullPrunedBlockStore(NetworkParameters params, int fullStoreDepth) {
        this.fullStoreDepth = fullStoreDepth > 0 ? fullStoreDepth : 1;
        try {
            StoredBlock storedGenesisHeader = new StoredBlock(params.getGenesisBlock().cloneAsHeader(), params.getGenesisBlock().getWork(), 0);
            LinkedList<Transaction> genesisTransactions = Lists.newLinkedList();
            StoredUndoableBlock storedGenesis = new StoredUndoableBlock(params.getGenesisBlock().getHash(), genesisTransactions);
            this.put(storedGenesisHeader, storedGenesis);
            this.setChainHead(storedGenesisHeader);
            this.setVerifiedChainHead(storedGenesisHeader);
            this.params = params;
        }
        catch (BlockStoreException e) {
            throw new RuntimeException(e);
        }
        catch (VerificationException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public synchronized void put(StoredBlock block) throws BlockStoreException {
        Preconditions.checkNotNull(this.blockMap, "MemoryFullPrunedBlockStore is closed");
        Sha256Hash hash = block.getHeader().getHash();
        this.blockMap.put(hash, new StoredBlockAndWasUndoableFlag(block, false));
    }

    @Override
    public final synchronized void put(StoredBlock storedBlock, StoredUndoableBlock undoableBlock) throws BlockStoreException {
        Preconditions.checkNotNull(this.blockMap, "MemoryFullPrunedBlockStore is closed");
        Sha256Hash hash = storedBlock.getHeader().getHash();
        this.fullBlockMap.put(hash, storedBlock.getHeight(), undoableBlock);
        this.blockMap.put(hash, new StoredBlockAndWasUndoableFlag(storedBlock, true));
    }

    @Override
    @Nullable
    public synchronized StoredBlock get(Sha256Hash hash) throws BlockStoreException {
        Preconditions.checkNotNull(this.blockMap, "MemoryFullPrunedBlockStore is closed");
        StoredBlockAndWasUndoableFlag storedBlock = this.blockMap.get(hash);
        return storedBlock == null ? null : storedBlock.block;
    }

    @Override
    @Nullable
    public synchronized StoredBlock getOnceUndoableStoredBlock(Sha256Hash hash) throws BlockStoreException {
        Preconditions.checkNotNull(this.blockMap, "MemoryFullPrunedBlockStore is closed");
        StoredBlockAndWasUndoableFlag storedBlock = this.blockMap.get(hash);
        return storedBlock != null && storedBlock.wasUndoable ? storedBlock.block : null;
    }

    @Override
    @Nullable
    public synchronized StoredUndoableBlock getUndoBlock(Sha256Hash hash) throws BlockStoreException {
        Preconditions.checkNotNull(this.fullBlockMap, "MemoryFullPrunedBlockStore is closed");
        return this.fullBlockMap.get(hash);
    }

    @Override
    public synchronized StoredBlock getChainHead() throws BlockStoreException {
        Preconditions.checkNotNull(this.blockMap, "MemoryFullPrunedBlockStore is closed");
        return this.chainHead;
    }

    @Override
    public final synchronized void setChainHead(StoredBlock chainHead) throws BlockStoreException {
        Preconditions.checkNotNull(this.blockMap, "MemoryFullPrunedBlockStore is closed");
        this.chainHead = chainHead;
    }

    @Override
    public synchronized StoredBlock getVerifiedChainHead() throws BlockStoreException {
        Preconditions.checkNotNull(this.blockMap, "MemoryFullPrunedBlockStore is closed");
        return this.verifiedChainHead;
    }

    @Override
    public final synchronized void setVerifiedChainHead(StoredBlock chainHead) throws BlockStoreException {
        Preconditions.checkNotNull(this.blockMap, "MemoryFullPrunedBlockStore is closed");
        this.verifiedChainHead = chainHead;
        if (this.chainHead.getHeight() < chainHead.getHeight()) {
            this.setChainHead(chainHead);
        }
        this.fullBlockMap.removeByMultiKey(chainHead.getHeight() - this.fullStoreDepth);
    }

    @Override
    public void close() {
        this.blockMap = null;
        this.fullBlockMap = null;
        this.transactionOutputMap = null;
    }

    @Override
    @Nullable
    public synchronized UTXO getTransactionOutput(Sha256Hash hash, long index) throws BlockStoreException {
        Preconditions.checkNotNull(this.transactionOutputMap, "MemoryFullPrunedBlockStore is closed");
        return this.transactionOutputMap.get(new StoredTransactionOutPoint(hash, index));
    }

    @Override
    public synchronized void addUnspentTransactionOutput(UTXO out) throws BlockStoreException {
        Preconditions.checkNotNull(this.transactionOutputMap, "MemoryFullPrunedBlockStore is closed");
        this.transactionOutputMap.put(new StoredTransactionOutPoint(out), out);
    }

    @Override
    public synchronized void removeUnspentTransactionOutput(UTXO out) throws BlockStoreException {
        Preconditions.checkNotNull(this.transactionOutputMap, "MemoryFullPrunedBlockStore is closed");
        if (this.transactionOutputMap.remove(new StoredTransactionOutPoint(out)) == null) {
            throw new BlockStoreException("Tried to remove a UTXO from MemoryFullPrunedBlockStore that it didn't have!");
        }
    }

    @Override
    public synchronized void beginDatabaseBatchWrite() throws BlockStoreException {
        this.blockMap.beginDatabaseBatchWrite();
        this.fullBlockMap.BeginTransaction();
        this.transactionOutputMap.beginDatabaseBatchWrite();
    }

    @Override
    public synchronized void commitDatabaseBatchWrite() throws BlockStoreException {
        this.blockMap.commitDatabaseBatchWrite();
        this.fullBlockMap.CommitTransaction();
        this.transactionOutputMap.commitDatabaseBatchWrite();
    }

    @Override
    public synchronized void abortDatabaseBatchWrite() throws BlockStoreException {
        this.blockMap.abortDatabaseBatchWrite();
        this.fullBlockMap.AbortTransaction();
        this.transactionOutputMap.abortDatabaseBatchWrite();
    }

    @Override
    public synchronized boolean hasUnspentOutputs(Sha256Hash hash, int numOutputs) throws BlockStoreException {
        for (int i = 0; i < numOutputs; ++i) {
            if (this.getTransactionOutput(hash, i) == null) continue;
            return true;
        }
        return false;
    }

    @Override
    public NetworkParameters getParams() {
        return this.params;
    }

    @Override
    public int getChainHeadHeight() throws UTXOProviderException {
        try {
            return this.getVerifiedChainHead().getHeight();
        }
        catch (BlockStoreException e) {
            throw new UTXOProviderException(e);
        }
    }

    @Override
    public List<UTXO> getOpenTransactionOutputs(List<ECKey> keys2) throws UTXOProviderException {
        ArrayList<UTXO> foundOutputs = new ArrayList<UTXO>();
        List<UTXO> outputsList = this.transactionOutputMap.values();
        for (UTXO output : outputsList) {
            for (ECKey key : keys2) {
                LegacyAddress address = LegacyAddress.fromKey(this.params, key);
                if (!output.getAddress().equals(((Object)address).toString())) continue;
                foundOutputs.add(output);
            }
        }
        return foundOutputs;
    }

    protected static class StoredBlockAndWasUndoableFlag {
        public StoredBlock block;
        public boolean wasUndoable;

        public StoredBlockAndWasUndoableFlag(StoredBlock block, boolean wasUndoable) {
            this.block = block;
            this.wasUndoable = wasUndoable;
        }
    }
}

