/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoinj.store;

import com.google.common.base.Objects;
import org.bitcoinj.core.Sha256Hash;
import org.bitcoinj.core.UTXO;

class StoredTransactionOutPoint {
    Sha256Hash hash;
    long index;

    StoredTransactionOutPoint(Sha256Hash hash, long index) {
        this.hash = hash;
        this.index = index;
    }

    StoredTransactionOutPoint(UTXO out) {
        this.hash = out.getHash();
        this.index = out.getIndex();
    }

    Sha256Hash getHash() {
        return this.hash;
    }

    long getIndex() {
        return this.index;
    }

    public int hashCode() {
        return Objects.hashCode(this.getIndex(), this.getHash());
    }

    public String toString() {
        return "Stored transaction out point: " + this.hash + ":" + this.index;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StoredTransactionOutPoint other = (StoredTransactionOutPoint)o;
        return this.getIndex() == other.getIndex() && Objects.equal(this.getHash(), other.getHash());
    }
}

