/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoinj.utils;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.NoSuchElementException;
import org.bitcoinj.core.Block;
import org.bitcoinj.core.NetworkParameters;
import org.bitcoinj.core.ProtocolException;
import org.bitcoinj.core.Utils;

public class BlockFileLoader
implements Iterable<Block>,
Iterator<Block> {
    private Iterator<File> fileIt;
    private File file = null;
    private FileInputStream currentFileStream = null;
    private Block nextBlock = null;
    private NetworkParameters params;

    public static List<File> getReferenceClientBlockFileList(File blocksDir) {
        File file;
        Preconditions.checkArgument(blocksDir.isDirectory(), "%s is not a directory", (Object)blocksDir);
        LinkedList<File> list = new LinkedList<File>();
        int i = 0;
        while ((file = new File(blocksDir, String.format(Locale.US, "blk%05d.dat", i))).exists()) {
            list.add(file);
            ++i;
        }
        return list;
    }

    public static List<File> getReferenceClientBlockFileList() {
        return BlockFileLoader.getReferenceClientBlockFileList(BlockFileLoader.defaultBlocksDir());
    }

    public static File defaultBlocksDir() {
        File defaultBlocksDir;
        if (Utils.isWindows()) {
            defaultBlocksDir = new File(System.getenv("APPDATA") + "\\.bitcoin\\blocks\\");
        } else if (Utils.isMac()) {
            defaultBlocksDir = new File(System.getProperty("user.home") + "/Library/Application Support/Bitcoin/blocks/");
        } else if (Utils.isLinux()) {
            defaultBlocksDir = new File(System.getProperty("user.home") + "/.bitcoin/blocks/");
        } else {
            throw new RuntimeException("Unsupported system");
        }
        return defaultBlocksDir;
    }

    public BlockFileLoader(NetworkParameters params, File blocksDir) {
        this(params, BlockFileLoader.getReferenceClientBlockFileList(blocksDir));
    }

    public BlockFileLoader(NetworkParameters params, List<File> files) {
        this.fileIt = files.iterator();
        this.params = params;
    }

    @Override
    public boolean hasNext() {
        if (this.nextBlock == null) {
            this.loadNextBlock();
        }
        return this.nextBlock != null;
    }

    @Override
    public Block next() throws NoSuchElementException {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        Block next = this.nextBlock;
        this.nextBlock = null;
        return next;
    }

    private void loadNextBlock() {
        while (true) {
            block18: {
                try {
                    if (this.fileIt.hasNext()) break block18;
                    if (this.currentFileStream == null) break;
                    if (this.currentFileStream.available() < 1) {
                    }
                    break block18;
                }
                catch (IOException e) {
                    this.currentFileStream = null;
                    if (this.fileIt.hasNext()) break block18;
                }
                break;
            }
            while (true) {
                try {
                    if (this.currentFileStream != null && this.currentFileStream.available() > 0) {
                        break;
                    }
                }
                catch (IOException e1) {
                    this.currentFileStream = null;
                }
                if (!this.fileIt.hasNext()) {
                    this.nextBlock = null;
                    this.currentFileStream = null;
                    return;
                }
                this.file = this.fileIt.next();
                try {
                    this.currentFileStream = new FileInputStream(this.file);
                }
                catch (FileNotFoundException e) {
                    this.currentFileStream = null;
                }
            }
            try {
                int nextChar = this.currentFileStream.read();
                while (nextChar != -1) {
                    if ((long)nextChar != (this.params.getPacketMagic() >>> 24 & 0xFFL)) {
                        nextChar = this.currentFileStream.read();
                        continue;
                    }
                    nextChar = this.currentFileStream.read();
                    if ((long)nextChar != (this.params.getPacketMagic() >>> 16 & 0xFFL) || (long)(nextChar = this.currentFileStream.read()) != (this.params.getPacketMagic() >>> 8 & 0xFFL) || (long)(nextChar = this.currentFileStream.read()) != (this.params.getPacketMagic() & 0xFFL)) continue;
                }
                byte[] bytes = new byte[4];
                this.currentFileStream.read(bytes, 0, 4);
                long size = Utils.readUint32BE(Utils.reverseBytes(bytes), 0);
                if (size > 2000000L || size <= 0L) continue;
                bytes = new byte[(int)size];
                this.currentFileStream.read(bytes, 0, (int)size);
                try {
                    this.nextBlock = this.params.getDefaultSerializer().makeBlock(bytes);
                }
                catch (ProtocolException e) {
                    this.nextBlock = null;
                    continue;
                }
                catch (Exception e) {
                    throw new RuntimeException("unexpected problem with block in " + this.file, e);
                }
            }
            catch (IOException e) {
                this.currentFileStream = null;
                continue;
            }
            break;
        }
    }

    @Override
    public void remove() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<Block> iterator() {
        return this;
    }
}

