/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoinj.utils;

import com.google.common.base.Throwables;
import java.util.concurrent.ThreadFactory;
import org.bitcoinj.core.Context;
import org.bitcoinj.utils.Threading;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContextPropagatingThreadFactory
implements ThreadFactory {
    private static final Logger log = LoggerFactory.getLogger(ContextPropagatingThreadFactory.class);
    private final String name;
    private final int priority;

    public ContextPropagatingThreadFactory(String name, int priority) {
        this.name = name;
        this.priority = priority;
    }

    public ContextPropagatingThreadFactory(String name) {
        this(name, 5);
    }

    @Override
    public Thread newThread(final Runnable r) {
        final Context context = Context.get();
        Thread thread2 = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Context.propagate(context);
                    r.run();
                }
                catch (Exception e) {
                    log.error("Exception in thread", e);
                    Throwables.propagate(e);
                }
            }
        }, this.name);
        thread2.setPriority(this.priority);
        thread2.setDaemon(true);
        Thread.UncaughtExceptionHandler handler = Threading.uncaughtExceptionHandler;
        if (handler != null) {
            thread2.setUncaughtExceptionHandler(handler);
        }
        return thread2;
    }
}

