/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoinj.wallet;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import java.util.List;
import javax.annotation.Nullable;
import org.bitcoinj.core.Utils;
import org.bitcoinj.crypto.EncryptableItem;
import org.bitcoinj.crypto.EncryptedData;
import org.bitcoinj.crypto.KeyCrypter;
import org.bitcoinj.crypto.MnemonicCode;
import org.bitcoinj.crypto.MnemonicException;
import org.bitcoinj.wallet.Protos;
import org.bitcoinj.wallet.UnreadableWalletException;
import org.bouncycastle.crypto.params.KeyParameter;

public class DeterministicSeed
implements EncryptableItem {
    public static final int DEFAULT_SEED_ENTROPY_BITS = 128;
    public static final int MAX_SEED_ENTROPY_BITS = 512;
    @Nullable
    private final byte[] seed;
    @Nullable
    private final List<String> mnemonicCode;
    @Nullable
    private final EncryptedData encryptedMnemonicCode;
    @Nullable
    private final EncryptedData encryptedSeed;
    private long creationTimeSeconds;

    public DeterministicSeed(String mnemonicCode, byte[] seed, String passphrase, long creationTimeSeconds) throws UnreadableWalletException {
        this(DeterministicSeed.decodeMnemonicCode(mnemonicCode), seed, passphrase, creationTimeSeconds);
    }

    public DeterministicSeed(byte[] seed, List<String> mnemonic, long creationTimeSeconds) {
        this.seed = Preconditions.checkNotNull(seed);
        this.mnemonicCode = Preconditions.checkNotNull(mnemonic);
        this.encryptedMnemonicCode = null;
        this.encryptedSeed = null;
        this.creationTimeSeconds = creationTimeSeconds;
    }

    public DeterministicSeed(EncryptedData encryptedMnemonic, @Nullable EncryptedData encryptedSeed, long creationTimeSeconds) {
        this.seed = null;
        this.mnemonicCode = null;
        this.encryptedMnemonicCode = Preconditions.checkNotNull(encryptedMnemonic);
        this.encryptedSeed = encryptedSeed;
        this.creationTimeSeconds = creationTimeSeconds;
    }

    public DeterministicSeed(List<String> mnemonicCode, @Nullable byte[] seed, String passphrase, long creationTimeSeconds) {
        this(seed != null ? seed : MnemonicCode.toSeed(mnemonicCode, Preconditions.checkNotNull(passphrase)), mnemonicCode, creationTimeSeconds);
    }

    public DeterministicSeed(SecureRandom random, int bits, String passphrase) {
        this(DeterministicSeed.getEntropy(random, bits), Preconditions.checkNotNull(passphrase), Utils.currentTimeSeconds());
    }

    public DeterministicSeed(byte[] entropy, String passphrase, long creationTimeSeconds) {
        Preconditions.checkArgument(entropy.length % 4 == 0, "entropy size in bits not divisible by 32");
        Preconditions.checkArgument(entropy.length * 8 >= 128, "entropy size too small");
        Preconditions.checkNotNull(passphrase);
        try {
            this.mnemonicCode = MnemonicCode.INSTANCE.toMnemonic(entropy);
        }
        catch (MnemonicException.MnemonicLengthException e) {
            throw new RuntimeException(e);
        }
        this.seed = MnemonicCode.toSeed(this.mnemonicCode, passphrase);
        this.encryptedMnemonicCode = null;
        this.encryptedSeed = null;
        this.creationTimeSeconds = creationTimeSeconds;
    }

    private static byte[] getEntropy(SecureRandom random, int bits) {
        Preconditions.checkArgument(bits <= 512, "requested entropy size too large");
        byte[] seed = new byte[bits / 8];
        random.nextBytes(seed);
        return seed;
    }

    @Override
    public boolean isEncrypted() {
        Preconditions.checkState(this.mnemonicCode != null || this.encryptedMnemonicCode != null);
        return this.encryptedMnemonicCode != null;
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean includePrivate) {
        MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper(this);
        if (this.isEncrypted()) {
            helper.addValue("encrypted");
        } else if (includePrivate) {
            helper.addValue(this.toHexString()).add("mnemonicCode", Utils.SPACE_JOINER.join(this.mnemonicCode));
        } else {
            helper.addValue("unencrypted");
        }
        return helper.toString();
    }

    @Nullable
    public String toHexString() {
        return this.seed != null ? Utils.HEX.encode(this.seed) : null;
    }

    @Override
    @Nullable
    public byte[] getSecretBytes() {
        return this.getMnemonicAsBytes();
    }

    @Nullable
    public byte[] getSeedBytes() {
        return this.seed;
    }

    @Override
    @Nullable
    public EncryptedData getEncryptedData() {
        return this.encryptedMnemonicCode;
    }

    @Override
    public Protos.Wallet.EncryptionType getEncryptionType() {
        return Protos.Wallet.EncryptionType.ENCRYPTED_SCRYPT_AES;
    }

    @Nullable
    public EncryptedData getEncryptedSeedData() {
        return this.encryptedSeed;
    }

    @Override
    public long getCreationTimeSeconds() {
        return this.creationTimeSeconds;
    }

    public void setCreationTimeSeconds(long creationTimeSeconds) {
        this.creationTimeSeconds = creationTimeSeconds;
    }

    public DeterministicSeed encrypt(KeyCrypter keyCrypter, KeyParameter aesKey) {
        Preconditions.checkState(this.encryptedMnemonicCode == null, "Trying to encrypt seed twice");
        Preconditions.checkState(this.mnemonicCode != null, "Mnemonic missing so cannot encrypt");
        EncryptedData encryptedMnemonic = keyCrypter.encrypt(this.getMnemonicAsBytes(), aesKey);
        EncryptedData encryptedSeed = keyCrypter.encrypt(this.seed, aesKey);
        return new DeterministicSeed(encryptedMnemonic, encryptedSeed, this.creationTimeSeconds);
    }

    private byte[] getMnemonicAsBytes() {
        return Utils.SPACE_JOINER.join(this.mnemonicCode).getBytes(StandardCharsets.UTF_8);
    }

    public DeterministicSeed decrypt(KeyCrypter crypter, String passphrase, KeyParameter aesKey) {
        Preconditions.checkState(this.isEncrypted());
        Preconditions.checkNotNull(this.encryptedMnemonicCode);
        List<String> mnemonic = DeterministicSeed.decodeMnemonicCode(crypter.decrypt(this.encryptedMnemonicCode, aesKey));
        byte[] seed = this.encryptedSeed == null ? null : crypter.decrypt(this.encryptedSeed, aesKey);
        return new DeterministicSeed(mnemonic, seed, passphrase, this.creationTimeSeconds);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DeterministicSeed other = (DeterministicSeed)o;
        return this.creationTimeSeconds == other.creationTimeSeconds && Objects.equal(this.encryptedMnemonicCode, other.encryptedMnemonicCode) && Objects.equal(this.mnemonicCode, other.mnemonicCode);
    }

    public int hashCode() {
        return Objects.hashCode(this.creationTimeSeconds, this.encryptedMnemonicCode, this.mnemonicCode);
    }

    public void check() throws MnemonicException {
        if (this.mnemonicCode != null) {
            MnemonicCode.INSTANCE.check(this.mnemonicCode);
        }
    }

    byte[] getEntropyBytes() throws MnemonicException {
        return MnemonicCode.INSTANCE.toEntropy(this.mnemonicCode);
    }

    @Nullable
    public List<String> getMnemonicCode() {
        return this.mnemonicCode;
    }

    private static List<String> decodeMnemonicCode(byte[] mnemonicCode) {
        return DeterministicSeed.decodeMnemonicCode(new String(mnemonicCode, StandardCharsets.UTF_8));
    }

    private static List<String> decodeMnemonicCode(String mnemonicCode) {
        return Splitter.on(" ").splitToList(mnemonicCode);
    }
}

