/*
 * Decompiled with CFR 0.152.
 */
package org.fxmisc.easybind;

import java.util.Collection;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;
import javafx.beans.Observable;
import javafx.beans.property.Property;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import org.fxmisc.easybind.ConditionalBinding;
import org.fxmisc.easybind.ListCombinationBinding;
import org.fxmisc.easybind.MappedList;
import org.fxmisc.easybind.PreboundBinding;
import org.fxmisc.easybind.Subscription;
import org.fxmisc.easybind.When;
import org.fxmisc.easybind.monadic.MonadicBinding;
import org.fxmisc.easybind.monadic.MonadicObservableValue;
import org.fxmisc.easybind.select.SelectBuilder;

public class EasyBind {
    public static <T> MonadicObservableValue<T> monadic(final ObservableValue<T> o) {
        if (o instanceof MonadicObservableValue) {
            return (MonadicObservableValue)o;
        }
        return new PreboundBinding<T>(new Observable[]{o}){

            @Override
            protected T computeValue() {
                return o.getValue();
            }
        };
    }

    public static <T, U> MonadicBinding<U> map(final ObservableValue<T> src, final Function<T, U> f) {
        return new PreboundBinding<U>(new Observable[]{src}){

            @Override
            protected U computeValue() {
                return f.apply(src.getValue());
            }
        };
    }

    public static <T, U> ObservableList<U> map(ObservableList<? extends T> sourceList, Function<? super T, ? extends U> f) {
        return new MappedList<U, T>(sourceList, f);
    }

    public static <A, B, R> MonadicBinding<R> combine(final ObservableValue<A> src1, final ObservableValue<B> src2, final BiFunction<A, B, R> f) {
        return new PreboundBinding<R>(new Observable[]{src1, src2}){

            @Override
            protected R computeValue() {
                return f.apply(src1.getValue(), src2.getValue());
            }
        };
    }

    public static <A, B, C, R> MonadicBinding<R> combine(final ObservableValue<A> src1, final ObservableValue<B> src2, final ObservableValue<C> src3, final TriFunction<A, B, C, R> f) {
        return new PreboundBinding<R>(new Observable[]{src1, src2, src3}){

            @Override
            protected R computeValue() {
                return f.apply(src1.getValue(), src2.getValue(), src3.getValue());
            }
        };
    }

    public static <A, B, C, D, R> MonadicBinding<R> combine(final ObservableValue<A> src1, final ObservableValue<B> src2, final ObservableValue<C> src3, final ObservableValue<D> src4, final TetraFunction<A, B, C, D, R> f) {
        return new PreboundBinding<R>(new Observable[]{src1, src2, src3, src4}){

            @Override
            protected R computeValue() {
                return f.apply(src1.getValue(), src2.getValue(), src3.getValue(), src4.getValue());
            }
        };
    }

    public static <A, B, C, D, E, R> MonadicBinding<R> combine(final ObservableValue<A> src1, final ObservableValue<B> src2, final ObservableValue<C> src3, final ObservableValue<D> src4, final ObservableValue<E> src5, final PentaFunction<A, B, C, D, E, R> f) {
        return new PreboundBinding<R>(new Observable[]{src1, src2, src3, src4, src5}){

            @Override
            protected R computeValue() {
                return f.apply(src1.getValue(), src2.getValue(), src3.getValue(), src4.getValue(), src5.getValue());
            }
        };
    }

    public static <A, B, C, D, E, F, R> MonadicBinding<R> combine(final ObservableValue<A> src1, final ObservableValue<B> src2, final ObservableValue<C> src3, final ObservableValue<D> src4, final ObservableValue<E> src5, final ObservableValue<F> src6, final HexaFunction<A, B, C, D, E, F, R> f) {
        return new PreboundBinding<R>(new Observable[]{src1, src2, src3, src4, src5, src6}){

            @Override
            protected R computeValue() {
                return f.apply(src1.getValue(), src2.getValue(), src3.getValue(), src4.getValue(), src5.getValue(), src6.getValue());
            }
        };
    }

    public static <T, R> MonadicBinding<R> combine(ObservableList<? extends ObservableValue<? extends T>> list, Function<? super Stream<T>, ? extends R> f) {
        return new ListCombinationBinding(list, f);
    }

    public static <T> SelectBuilder<T> select(ObservableValue<T> selectionRoot) {
        return SelectBuilder.startAt(selectionRoot);
    }

    @Deprecated
    public static <T> Subscription bindConditionally(Property<T> target, ObservableValue<? extends T> source, ObservableValue<Boolean> condition) {
        return new ConditionalBinding<T>(target, source, condition);
    }

    public static <T> Subscription listBind(List<? super T> target, ObservableList<? extends T> source) {
        target.clear();
        target.addAll(source);
        ListChangeListener listener = change -> {
            while (change.next()) {
                int from = change.getFrom();
                int to = change.getTo();
                if (change.wasPermutated()) {
                    target.subList(from, to).clear();
                    target.addAll(from, source.subList(from, to));
                    continue;
                }
                target.subList(from, from + change.getRemovedSize()).clear();
                target.addAll(from, source.subList(from, from + change.getAddedSize()));
            }
        };
        source.addListener(listener);
        return () -> source.removeListener(listener);
    }

    public static When when(ObservableValue<Boolean> condition) {
        return new When(condition);
    }

    public static <T> Subscription includeWhen(final Collection<T> collection, final T element, ObservableValue<Boolean> condition) {
        return EasyBind.subscribe(condition, new Consumer<Boolean>(){
            private boolean included = false;

            @Override
            public void accept(Boolean value) {
                if (value.booleanValue() && !this.included) {
                    this.included = collection.add(element);
                } else if (!value.booleanValue() && this.included) {
                    collection.remove(element);
                    this.included = false;
                }
            }
        });
    }

    public static <T> Subscription subscribe(ObservableValue<T> observable2, Consumer<? super T> subscriber) {
        subscriber.accept(observable2.getValue());
        ChangeListener<Object> listener = (obs, oldValue, newValue) -> subscriber.accept(newValue);
        observable2.addListener(listener);
        return () -> observable2.removeListener(listener);
    }

    @FunctionalInterface
    public static interface HexaFunction<A, B, C, D, E, F, R> {
        public R apply(A var1, B var2, C var3, D var4, E var5, F var6);
    }

    @FunctionalInterface
    public static interface PentaFunction<A, B, C, D, E, R> {
        public R apply(A var1, B var2, C var3, D var4, E var5);
    }

    @FunctionalInterface
    public static interface TetraFunction<A, B, C, D, R> {
        public R apply(A var1, B var2, C var3, D var4);
    }

    @FunctionalInterface
    public static interface TriFunction<A, B, C, R> {
        public R apply(A var1, B var2, C var3);
    }
}

