/*
 * Decompiled with CFR 0.152.
 */
package org.fxmisc.easybind;

import java.util.function.Function;
import java.util.stream.Stream;
import javafx.beans.InvalidationListener;
import javafx.beans.WeakInvalidationListener;
import javafx.beans.binding.ObjectBinding;
import javafx.beans.value.ObservableValue;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.collections.WeakListChangeListener;
import org.fxmisc.easybind.monadic.MonadicBinding;

class ListCombinationBinding<T, U>
extends ObjectBinding<U>
implements MonadicBinding<U> {
    private final ListChangeListener<ObservableValue<? extends T>> listListener = ch -> this.sourceChanged(ch);
    private final InvalidationListener elemListener = obs -> this.elementInvalidated();
    private final WeakListChangeListener<ObservableValue<? extends T>> weakListListener = new WeakListChangeListener<ObservableValue<T>>(this.listListener);
    private final WeakInvalidationListener weakElemListener = new WeakInvalidationListener(this.elemListener);
    private final ObservableList<? extends ObservableValue<? extends T>> source;
    private final Function<? super Stream<T>, ? extends U> combiner;

    public ListCombinationBinding(ObservableList<? extends ObservableValue<? extends T>> list, Function<? super Stream<T>, ? extends U> f) {
        this.source = list;
        this.combiner = f;
        this.source.addListener(this.weakListListener);
        this.source.forEach(elem -> elem.addListener(this.weakElemListener));
    }

    @Override
    protected U computeValue() {
        return this.combiner.apply(this.source.stream().map((? super T obs) -> obs.getValue()));
    }

    @Override
    public void dispose() {
        this.source.forEach(elem -> elem.removeListener(this.weakElemListener));
        this.source.removeListener(this.weakListListener);
    }

    private void sourceChanged(ListChangeListener.Change<? extends ObservableValue<? extends T>> ch) {
        while (ch.next()) {
            ch.getRemoved().forEach(elem -> elem.removeListener(this.weakElemListener));
            ch.getAddedSubList().forEach(elem -> elem.addListener(this.weakElemListener));
            this.invalidate();
        }
    }

    private void elementInvalidated() {
        this.invalidate();
    }
}

