/*
 * Decompiled with CFR 0.152.
 */
package org.fxmisc.easybind;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.collections.transformation.TransformationList;

class MappedList<E, F>
extends TransformationList<E, F> {
    private final Function<? super F, ? extends E> mapper;

    public MappedList(ObservableList<? extends F> source, Function<? super F, ? extends E> mapper) {
        super(source);
        this.mapper = mapper;
    }

    @Override
    public int getSourceIndex(int index) {
        return index;
    }

    @Override
    public E get(int index) {
        return this.mapper.apply(this.getSource().get(index));
    }

    @Override
    public int size() {
        return this.getSource().size();
    }

    @Override
    protected void sourceChanged(final ListChangeListener.Change<? extends F> c) {
        this.fireChange(new ListChangeListener.Change<E>(this){

            @Override
            public boolean wasAdded() {
                return c.wasAdded();
            }

            @Override
            public boolean wasRemoved() {
                return c.wasRemoved();
            }

            @Override
            public boolean wasReplaced() {
                return c.wasReplaced();
            }

            @Override
            public boolean wasUpdated() {
                return c.wasUpdated();
            }

            @Override
            public boolean wasPermutated() {
                return c.wasPermutated();
            }

            @Override
            public int getPermutation(int i) {
                return c.getPermutation(i);
            }

            @Override
            protected int[] getPermutation() {
                throw new AssertionError((Object)"Unreachable code");
            }

            @Override
            public List<E> getRemoved() {
                ArrayList res = new ArrayList(c.getRemovedSize());
                for (Object e : c.getRemoved()) {
                    res.add(MappedList.this.mapper.apply(e));
                }
                return res;
            }

            @Override
            public int getFrom() {
                return c.getFrom();
            }

            @Override
            public int getTo() {
                return c.getTo();
            }

            @Override
            public boolean next() {
                return c.next();
            }

            @Override
            public void reset() {
                c.reset();
            }
        });
    }
}

