/*
 * Decompiled with CFR 0.152.
 */
package org.fxmisc.easybind.monadic;

import java.util.function.Function;
import javafx.beans.InvalidationListener;
import javafx.beans.WeakInvalidationListener;
import javafx.beans.binding.ObjectBinding;
import javafx.beans.value.ObservableValue;
import org.fxmisc.easybind.Subscription;
import org.fxmisc.easybind.monadic.MonadicBinding;

abstract class FlatMapBindingBase<T, U, O extends ObservableValue<U>>
extends ObjectBinding<U>
implements MonadicBinding<U> {
    private final ObservableValue<T> src;
    private final Function<? super T, O> mapper;
    private final InvalidationListener srcListener = obs -> this.srcInvalidated();
    private final InvalidationListener mappedListener = obs -> this.mappedInvalidated();
    private final InvalidationListener weakSrcListener = new WeakInvalidationListener(this.srcListener);
    private final InvalidationListener weakMappedListener = new WeakInvalidationListener(this.mappedListener);
    private O mapped = null;
    private Subscription mappedSubscription = null;

    public FlatMapBindingBase(ObservableValue<T> src, Function<? super T, O> f) {
        this.src = src;
        this.mapper = f;
        src.addListener(this.weakSrcListener);
    }

    @Override
    public final void dispose() {
        this.src.removeListener(this.weakSrcListener);
        this.disposeMapped();
    }

    @Override
    protected final U computeValue() {
        this.setupTargetObservable();
        return this.mapped != null ? (U)this.mapped.getValue() : null;
    }

    private void setupTargetObservable() {
        T baseVal;
        if (this.mapped == null && (baseVal = this.src.getValue()) != null) {
            this.mapped = (ObservableValue)this.mapper.apply(baseVal);
            this.mappedSubscription = this.observeTargetObservable(this.mapped);
        }
    }

    protected O getTargetObservable() {
        this.setupTargetObservable();
        return this.mapped;
    }

    protected Subscription observeTargetObservable(O target) {
        target.addListener(this.weakMappedListener);
        return () -> target.removeListener(this.weakMappedListener);
    }

    private void disposeMapped() {
        if (this.mapped != null) {
            this.mappedSubscription.unsubscribe();
            this.mappedSubscription = null;
            this.mapped = null;
        }
    }

    private void mappedInvalidated() {
        this.invalidate();
    }

    protected void srcInvalidated() {
        this.disposeMapped();
        this.invalidate();
    }
}

