/*
 * Decompiled with CFR 0.152.
 */
package org.fxmisc.easybind.select;

import javafx.beans.InvalidationListener;
import javafx.beans.binding.ObjectBinding;
import javafx.beans.value.ObservableValue;
import org.fxmisc.easybind.monadic.MonadicBinding;
import org.fxmisc.easybind.select.NestedSelectionElement;
import org.fxmisc.easybind.select.NestedSelectionElementFactory;

class SelectObjectBinding<T, U>
extends ObjectBinding<U>
implements MonadicBinding<U> {
    private final ObservableValue<T> root;
    private final NestedSelectionElement<T, U> nestedSelection;
    private final InvalidationListener rootInvalidationListener;

    public SelectObjectBinding(ObservableValue<T> root, NestedSelectionElementFactory<T, U> nestedSelectionFactory) {
        this.root = root;
        this.nestedSelection = nestedSelectionFactory.create(this::invalidate);
        this.rootInvalidationListener = obs -> {
            this.nestedSelection.disconnect();
            this.invalidate();
        };
        root.addListener(this.rootInvalidationListener);
    }

    @Override
    protected U computeValue() {
        if (!this.nestedSelection.isConnected()) {
            T rootVal = this.root.getValue();
            if (rootVal == null) {
                return null;
            }
            this.nestedSelection.connect(rootVal);
        }
        return this.nestedSelection.getValue();
    }

    @Override
    public void dispose() {
        this.root.removeListener(this.rootInvalidationListener);
        this.nestedSelection.disconnect();
    }
}

