/*
 * Decompiled with CFR 0.152.
 */
package org.zeromq;

import java.io.Closeable;
import java.nio.channels.Selector;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.zeromq.SocketType;
import org.zeromq.ZMQ;
import org.zeromq.ZThread;

public class ZContext
implements Closeable {
    private final ZMQ.Context context;
    private final Set<ZMQ.Socket> sockets = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Set<Selector> selectors = Collections.newSetFromMap(new ConcurrentHashMap());
    private final int ioThreads;
    private final boolean main;
    private volatile int linger;
    private int pipehwm;
    private volatile int sndhwm;
    private volatile int rcvhwm;

    public ZContext() {
        this(1);
    }

    public ZContext(int ioThreads) {
        this(ZMQ.context(ioThreads), true, ioThreads);
    }

    private ZContext(ZMQ.Context context, boolean main, int ioThreads) {
        this.context = context;
        this.ioThreads = ioThreads;
        this.main = main;
        this.linger = 0;
        this.pipehwm = 1000;
        this.sndhwm = 1000;
        this.rcvhwm = 1000;
    }

    public void destroy() {
        for (ZMQ.Socket socket : this.sockets) {
            this.destroySocket(socket);
        }
        this.sockets.clear();
        for (Selector selector : this.selectors) {
            this.context.close(selector);
        }
        this.selectors.clear();
        if (this.isMain()) {
            this.context.term();
        }
    }

    public ZMQ.Socket createSocket(SocketType type) {
        ZMQ.Socket socket = this.context.socket(type);
        socket.setRcvHWM(this.rcvhwm);
        socket.setSndHWM(this.sndhwm);
        this.sockets.add(socket);
        return socket;
    }

    @Deprecated
    public ZMQ.Socket createSocket(int type) {
        return this.createSocket(SocketType.type(type));
    }

    public void destroySocket(ZMQ.Socket s2) {
        if (s2 == null) {
            return;
        }
        s2.setLinger(this.linger);
        s2.close();
        this.sockets.remove(s2);
    }

    @Deprecated
    public Selector createSelector() {
        return this.selector();
    }

    Selector selector() {
        Selector selector = this.context.selector();
        this.selectors.add(selector);
        return selector;
    }

    @Deprecated
    public void closeSelector(Selector selector) {
        if (this.selectors.remove(selector)) {
            this.context.close(selector);
        }
    }

    public ZMQ.Poller createPoller(int size) {
        return new ZMQ.Poller(this.context, size);
    }

    public static ZContext shadow(ZContext ctx) {
        ZContext context = new ZContext(ctx.context, false, ctx.ioThreads);
        context.linger = ctx.linger;
        context.sndhwm = ctx.sndhwm;
        context.rcvhwm = ctx.rcvhwm;
        context.pipehwm = ctx.pipehwm;
        return context;
    }

    public ZMQ.Socket fork(ZThread.IAttachedRunnable runnable, Object ... args2) {
        return ZThread.fork(this, runnable, args2);
    }

    public int getIoThreads() {
        return this.ioThreads;
    }

    @Deprecated
    public void setIoThreads(int ioThreads) {
    }

    public int getLinger() {
        return this.linger;
    }

    public void setLinger(int linger) {
        this.linger = linger;
    }

    public void setRcvHWM(int rcvhwm) {
        this.rcvhwm = rcvhwm;
    }

    public void setSndHWM(int sndhwm) {
        this.sndhwm = sndhwm;
    }

    public boolean isMain() {
        return this.main;
    }

    @Deprecated
    public void setMain(boolean main) {
    }

    public ZMQ.Context getContext() {
        return this.context;
    }

    @Deprecated
    public void setContext(ZMQ.Context ctx) {
    }

    public List<ZMQ.Socket> getSockets() {
        return new ArrayList<ZMQ.Socket>(this.sockets);
    }

    @Override
    public void close() {
        this.destroy();
    }

    public boolean isClosed() {
        return this.context.isClosed();
    }
}

