/*
 * Decompiled with CFR 0.152.
 */
package zmq;

import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.SocketChannel;
import java.util.Arrays;
import zmq.ZMQ;
import zmq.io.Metadata;
import zmq.util.Utils;
import zmq.util.Wire;

public class Msg {
    public static final int MORE = 1;
    public static final int COMMAND = 2;
    public static final int CREDENTIAL = 32;
    public static final int IDENTITY = 64;
    public static final int SHARED = 128;
    private Metadata metadata;
    private int flags;
    private Type type;
    private SocketChannel fileDesc;
    private final int size;
    private final ByteBuffer buf;
    private int writeIndex = 0;
    private int readIndex = 0;

    public Msg() {
        this(0);
    }

    public Msg(int capacity) {
        this.type = Type.DATA;
        this.flags = 0;
        this.size = capacity;
        this.buf = ByteBuffer.wrap(new byte[capacity]).order(ByteOrder.BIG_ENDIAN);
    }

    public Msg(byte[] src) {
        if (src == null) {
            src = new byte[]{};
        }
        this.type = Type.DATA;
        this.flags = 0;
        this.size = src.length;
        this.buf = ByteBuffer.wrap(src).order(ByteOrder.BIG_ENDIAN);
    }

    public Msg(ByteBuffer src) {
        if (src == null) {
            throw new IllegalArgumentException("ByteBuffer cannot be null");
        }
        this.type = Type.DATA;
        this.flags = 0;
        this.buf = src.duplicate();
        this.size = this.buf.remaining();
    }

    public Msg(Msg m4) {
        if (m4 == null) {
            throw new IllegalArgumentException("Msg cannot be null");
        }
        this.type = m4.type;
        this.flags = m4.flags;
        this.size = m4.size;
        this.buf = m4.buf != null ? m4.buf.duplicate() : null;
    }

    private Msg(Msg src, ByteArrayOutputStream out) {
        this(ByteBuffer.wrap(out.toByteArray()));
        this.type = src.type;
        this.flags = src.flags;
    }

    public boolean isIdentity() {
        return (this.flags & 0x40) == 64;
    }

    public boolean isDelimiter() {
        return this.type == Type.DELIMITER;
    }

    public boolean check() {
        return true;
    }

    public int flags() {
        return this.flags;
    }

    public boolean hasMore() {
        return (this.flags & 1) > 0;
    }

    public boolean isCommand() {
        return (this.flags & 2) == 2;
    }

    public boolean isCredential() {
        return (this.flags & 0x20) == 32;
    }

    public void setFlags(int flags) {
        this.flags |= flags;
    }

    public void initDelimiter() {
        this.type = Type.DELIMITER;
        this.metadata = null;
        this.flags = 0;
    }

    public byte[] data() {
        if (this.buf.hasArray()) {
            byte[] array = this.buf.array();
            int offset = this.buf.arrayOffset();
            if (this.buf.arrayOffset() == 0 && array.length == this.size) {
                return array;
            }
            return Arrays.copyOfRange(array, offset, offset + this.size);
        }
        byte[] array = new byte[this.size];
        ByteBuffer dup = this.buf.duplicate();
        dup.position(0);
        dup.get(array);
        return array;
    }

    public ByteBuffer buf() {
        return this.buf.duplicate();
    }

    public int size() {
        return this.size;
    }

    public void resetFlags(int f) {
        this.flags &= ~f;
    }

    public void setFd(SocketChannel fileDesc) {
        this.fileDesc = fileDesc;
    }

    public SocketChannel fd() {
        return this.fileDesc;
    }

    public Metadata getMetadata() {
        return this.metadata;
    }

    public Msg setMetadata(Metadata metadata) {
        this.metadata = metadata;
        return this;
    }

    public void resetMetadata() {
        this.setMetadata(null);
    }

    public byte get() {
        return this.get(this.readIndex++);
    }

    public byte get(int index) {
        return this.buf.get(index);
    }

    public Msg put(byte b) {
        return this.put(this.writeIndex++, b);
    }

    public Msg put(int b) {
        return this.put(this.writeIndex++, (byte)b);
    }

    protected Msg put(int index, byte b) {
        this.buf.put(index, b);
        return this;
    }

    public Msg put(byte[] src) {
        return this.put(src, 0, src.length);
    }

    public Msg put(byte[] src, int off, int len) {
        if (src == null) {
            return this;
        }
        ByteBuffer dup = this.buf.duplicate();
        dup.position(this.writeIndex);
        this.writeIndex += len;
        dup.put(src, off, len);
        return this;
    }

    public Msg put(ByteBuffer src, int off, int len) {
        if (src == null) {
            return this;
        }
        int position = src.position();
        int limit = src.limit();
        src.limit(off + len).position(off);
        this.put(src);
        src.limit(limit).position(position);
        return this;
    }

    public Msg put(ByteBuffer src) {
        ByteBuffer dup = this.buf.duplicate();
        dup.position(this.writeIndex);
        this.writeIndex += Math.min(dup.remaining(), src.remaining());
        dup.put(src);
        return this;
    }

    public int getBytes(int index, byte[] dst, int off, int len) {
        int count = Math.min(len, this.size - index);
        if (this.buf.hasArray()) {
            System.arraycopy(this.buf.array(), this.buf.arrayOffset() + index, dst, off, count);
        } else {
            ByteBuffer dup = this.buf.duplicate();
            dup.position(index);
            dup.get(dst, off, count);
        }
        return count;
    }

    public int getBytes(int index, ByteBuffer bb, int len) {
        ByteBuffer dup = this.buf.duplicate();
        dup.position(index);
        int count = Math.min(bb.remaining(), dup.remaining());
        count = Math.min(count, len);
        bb.put(dup);
        return count;
    }

    public String toString() {
        return String.format("#zmq.Msg{type=%s, size=%s, flags=%s}", new Object[]{this.type, this.size, this.flags});
    }

    protected final int getWriteIndex() {
        return this.writeIndex;
    }

    protected final void setWriteIndex(int writeIndex) {
        this.writeIndex = writeIndex;
    }

    public long getLong(int offset) {
        return Wire.getUInt64(this.buf, offset);
    }

    public int getInt(int offset) {
        return Wire.getUInt32(this.buf, offset);
    }

    public int getShort(int offset) {
        return Wire.getUInt16(this.buf, offset);
    }

    public void transfer(ByteBuffer destination, int srcOffset, int srcLength) {
        int position = this.buf.position();
        int limit = this.buf.limit();
        this.buf.limit(srcOffset + srcLength).position(srcOffset);
        destination.put(this.buf);
        this.buf.limit(limit).position(position);
    }

    public Msg putShortString(String data) {
        if (data == null) {
            return this;
        }
        ByteBuffer dup = this.buf.duplicate();
        dup.position(this.writeIndex);
        this.writeIndex += Wire.putShortString(dup, data);
        return this;
    }

    static enum Type {
        DATA,
        DELIMITER;

    }

    public static final class Builder
    extends Msg {
        private final ByteArrayOutputStream out = new ByteArrayOutputStream();

        @Override
        public int size() {
            return this.out.size();
        }

        @Override
        protected Msg put(int index, byte b) {
            this.out.write(b);
            return this;
        }

        @Override
        public Msg put(byte[] src, int off, int len) {
            if (src == null) {
                return this;
            }
            this.out.write(src, off, len);
            this.setWriteIndex(this.getWriteIndex() + len);
            return this;
        }

        @Override
        public Msg put(ByteBuffer src, int off, int len) {
            if (src == null) {
                return this;
            }
            for (int idx = off; idx < off + len; ++idx) {
                this.out.write(src.get(idx));
            }
            this.setWriteIndex(this.getWriteIndex() + len);
            return this;
        }

        @Override
        public Msg putShortString(String data) {
            if (data == null) {
                return this;
            }
            int length = data.length();
            Utils.checkArgument(length < 256, "String must be strictly smaller than 256 characters");
            this.out.write((byte)length);
            this.out.write(data.getBytes(ZMQ.CHARSET), 0, length);
            this.setWriteIndex(this.getWriteIndex() + length + 1);
            return this;
        }

        @Override
        public void setFlags(int flags) {
            super.setFlags(flags);
        }

        public Msg build() {
            return new Msg(this, this.out);
        }
    }
}

